/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.text.MessageFormat;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.SVNAdmin;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;

public class JhlClientAdapter
extends AbstractJhlClientAdapter {
    private SVNAdmin svnAdmin;
    private static boolean availabilityCached = false;
    private static boolean available;
    private static StringBuffer javaHLErrors;

    public JhlClientAdapter() {
        this.svnClient = new SVNClient();
        this.svnAdmin = new SVNAdmin();
        this.notificationHandler = new JhlNotificationHandler();
        this.svnClient.notification2((Notify2)this.notificationHandler);
        this.svnClient.setPrompt((PromptUserPassword)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailable() {
        if (!availabilityCached) {
            String string;
            block43: {
                if (JhlClientAdapter.isOsWindows()) {
                    try {
                        System.loadLibrary("libapr");
                    }
                    catch (Exception exception) {
                        javaHLErrors.append(exception.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        javaHLErrors.append(unsatisfiedLinkError.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("libapriconv");
                    }
                    catch (Exception exception) {
                        javaHLErrors.append(exception.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        javaHLErrors.append(unsatisfiedLinkError.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("libeay32");
                    }
                    catch (Exception exception) {
                        javaHLErrors.append(exception.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        javaHLErrors.append(unsatisfiedLinkError.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("libdb43");
                    }
                    catch (Exception exception) {
                        javaHLErrors.append(exception.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        javaHLErrors.append(unsatisfiedLinkError.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("ssleay32");
                    }
                    catch (Exception exception) {
                        javaHLErrors.append(exception.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        javaHLErrors.append(unsatisfiedLinkError.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("libaprutil");
                    }
                    catch (Exception exception) {
                        javaHLErrors.append(exception.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        javaHLErrors.append(unsatisfiedLinkError.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("intl3_svn");
                    }
                    catch (Exception exception) {
                        javaHLErrors.append(exception.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        javaHLErrors.append(unsatisfiedLinkError.getMessage()).append("\n");
                    }
                }
                available = false;
                try {
                    try {
                        string = System.getProperty("subversion.native.library");
                        if (string != null) {
                            System.load(string);
                            available = true;
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        javaHLErrors.append(unsatisfiedLinkError.getMessage()).append("\n");
                    }
                    if (available) break block43;
                    try {
                        System.loadLibrary("libsvnjavahl-1");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        javaHLErrors.append(unsatisfiedLinkError.getMessage() + "\n");
                        try {
                            System.loadLibrary("svnjavahl-1");
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                            javaHLErrors.append(unsatisfiedLinkError2.getMessage()).append("\n");
                            System.loadLibrary("svnjavahl");
                        }
                    }
                    available = true;
                }
                catch (Exception exception) {
                    available = false;
                    javaHLErrors.append(exception.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    available = false;
                    javaHLErrors.append(unsatisfiedLinkError.getMessage()).append("\n");
                }
                finally {
                    availabilityCached = true;
                }
            }
            if (!available) {
                string = System.getProperty("java.library.path");
                if (string != null) {
                    javaHLErrors.append("java.library.path = " + string);
                }
            } else {
                try {
                    string = new SVNClient();
                    String string2 = string.getAdminDirectoryName();
                    if (string2 != null) {
                        available = true;
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    available = false;
                    javaHLErrors.append("Incompatible JavaHL library loaded.  1.3.x or later required.");
                }
            }
        }
        return available;
    }

    public static String getLibraryLoadErrors() {
        if (JhlClientAdapter.isAvailable()) {
            return "";
        }
        return javaHLErrors.toString();
    }

    public void createRepository(File file, String string) throws SVNClientException {
        try {
            if (string == null) {
                string = "bdb";
            }
            this.notificationHandler.setCommand(23);
            String string2 = JhlClientAdapter.fileToSVNPath(file, false);
            this.notificationHandler.logCommandLine(MessageFormat.format("create --fstype {0} {1}", string, string2));
            this.svnAdmin.create(string2, false, false, null, string);
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }

    static {
        javaHLErrors = new StringBuffer("Failed to load JavaHL Library.\nThese are the errors that were encountered:\n");
    }
}

